/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;

public interface ModifierModule
extends GenericLoaderRegistry.IHaveLoader<ModifierModule> {
    public static final GenericLoaderRegistry<ModifierModule> LOADER = new GenericLoaderRegistry();

    public List<ModifierHook<?>> getDefaultHooks();

    @Nullable
    default public Integer getPriority() {
        return null;
    }

    public static ModifierHookMap createMap(List<ModuleWithHooks> modules) {
        ModifierHookMap.Builder builder = new ModifierHookMap.Builder();
        for (ModuleWithHooks module : modules) {
            for (ModifierHook<?> hook : module.getModuleHooks()) {
                builder.addHookChecked(module.module(), hook);
            }
        }
        return builder.build();
    }

    public record ModuleWithHooks(ModifierModule module, List<ModifierHook<?>> hooks) {
        public List<ModifierHook<?>> getModuleHooks() {
            if (this.hooks.isEmpty()) {
                return this.module.getDefaultHooks();
            }
            return this.hooks;
        }

        public JsonObject serialize() {
            JsonElement json = LOADER.serialize(this.module);
            if (!json.isJsonObject()) {
                throw new JsonSyntaxException("Serializers for modifier modules must return json objects");
            }
            JsonObject object = json.getAsJsonObject();
            if (!this.hooks.isEmpty()) {
                JsonArray hooks = new JsonArray();
                for (ModifierHook<?> hook : this.hooks) {
                    hooks.add(hook.getName().toString());
                }
                object.add("hooks", (JsonElement)hooks);
            }
            return object;
        }

        public static ModuleWithHooks deserialize(JsonObject json) {
            List<ModifierHook<?>> hooks = Collections.emptyList();
            if (json.has("hooks")) {
                hooks = JsonHelper.parseList(json, "hooks", (element, key) -> {
                    class_2960 name = JsonHelper.convertToResourceLocation(element, key);
                    ModifierHook<?> hook = ModifierHooks.getHook(name);
                    if (hook == null) {
                        throw new JsonSyntaxException("Unknown modifier hook " + name);
                    }
                    return hook;
                });
            }
            ModifierModule module = LOADER.deserialize((JsonElement)json);
            return new ModuleWithHooks(module, hooks);
        }

        public void toNetwork(class_2540 buffer) {
            buffer.method_10804(this.hooks.size());
            for (ModifierHook<?> hook : this.hooks) {
                buffer.method_10812(hook.getName());
            }
            LOADER.toNetwork(this.module, buffer);
        }

        public static ModuleWithHooks fromNetwork(class_2540 buffer) {
            int hookCount = buffer.method_10816();
            ImmutableList.Builder hooks = ImmutableList.builder();
            for (int i = 0; i < hookCount; ++i) {
                class_2960 location = buffer.method_10810();
                ModifierHook<?> hook = ModifierHooks.getHook(location);
                if (hook == null) {
                    throw new DecoderException("Unknown modifier hook " + location);
                }
                hooks.add(hook);
            }
            ModifierModule module = LOADER.fromNetwork(buffer);
            return new ModuleWithHooks(module, (List<ModifierHook<?>>)hooks.build());
        }
    }
}

